::###==========================================================================###
::###   Script created by Noel Morrison (HP), Systems Administrator VA         ###
::###                                                                          ###
::###   Purpose: Run the WMI executable binary and check the Runtime, re-run   ###
::###            if not about # of minutes duration, notify BMS Team of        ###
::###            any Failures via monitoring team, possible other means        ###
::###   Syntax:    Read f_USAGE Function below                                 ###
::###                                                                          ###
::###   Additional Note:                                                       ###
::###                                                                          ###
::###   Development Needs:                                                     ###
::###                                                                          ###
::###==========================================================================###
::
::###                     -->     Version History     <--                      ###
::
::###==========================================================================###
::###   Date Started:                                                          ###
::###   Version 1.0  Initial Script                              10-29-2014    ###
::###     This Script is Used to check the Last status of the WMI job, runs at ###
::###     11:05 pm CT on the SQL server                                        ###
::###   Version 1.0.1                                            10-30-2014    ###
::###     Tommy Noonan, added extra lines and a Few files to Send Introscope   ###
::###     Tid Bits so Introscope could track and handle any issue already      ###
::###     built-in to introscope's capacities.                                 ###
::###   Version 1.0.2                                            10-31-2014    ###
::###     Added Extra Logging of Introscope calls and Clean up of 30+ day old  ###
::###     logs.                                                                ###
::###==========================================================================###
::
::###==========================###
::###   Source Other Scripts   ###
::###==========================###

      ::   NONE at this Time

::###===============###
::###   Variables   ###
::###===============###

@ECHO OFF
REM MODE CON COLS=150 LINES=60&     ECHO FOR DEBUG/TESTING ONLY
REM     ####          #            #   #                  #           #       ##
REM    #       ###   ####          #   #   ####  # ##           ####  ####     #     ###    ####
REM     ###   #####   #             # #   #   #  ##       #    #   #  #   #    #    #####  ###
REM        #  #       #             # #   #  ##  #        #    #  ##  #   #    #    #        ###
REM    ####    ###     ##            #     ## #  #        #     ## #  ####    ###    ###   ####
SET WMI_PATH=D:\BMS\Data\WMI_UserGroup
SET v_MIN_MINS=8
SET SECOND_RUN=%~1
FOR /f "tokens=3 delims=: " %%a in ('time /T') DO SET "ampm=%%a"
SET "TODAY=%date:~10,4%-%date:~4,2%-%date:~7,2%"
SET "NOW=%time:~0,2%.%time:~3,2%.%time:~6,2%.%ampm%"
SET "NOW=%NOW: =0%" &   REM   Remove the ' ' Replace with '0', Replace SPACE Padding with '0' Padded.
SET "v_LOGFILE=%WMI_PATH%\LOGS\%TODAY%.%NOW%.log"
SET "v_RERUN=N"

REM    #   #    #     ###   #   #          ###    ###   ####   #####          ####  #####   ###   #####   ###    ###   #   #
REM    ## ##   # #     #    ##  #         #   #  #   #  #   #  #             #      #      #   #    #      #    #   #  ##  #
REM    # # #  #   #    #    # # #         #      #   #  #   #  ####           ###   ####   #        #      #    #   #  # # #
REM    # # #  #####    #    #  ##         #   #  #   #  #   #  #                 #  #      #   #    #      #    #   #  #  ##
REM    #   #  #   #   ###   #   #          ###    ###   ####   #####         ####   #####   ###     #     ###    ###   #   #

SET STARTTIME=%TIME%
CALL :LOG_OUTPUT "Started WMI_Wrapper @ %STARTTIME%"
IF EXIST %WMI_PATH%\FAIL.txt DEL /F %WMI_PATH%\FAIL.txt
MKDIR %WMI_PATH%\LOGS\ 2>NUL
REM   PING -n 40 -w 1 127.0.0.1 >NUL&     ECHO for DEBUG/TESTING PURPOSES ONLY
CALL %WMI_PATH%\WMI_UserGroup.exe
CALL :LOG_OUTPUT "Exit Status of WMI TASK: %errorlevel%"


SET ENDTIME=%TIME%

REM    #####  #   #  ####          #   #    #     ###   #   #          ###    ###   ####   #####
REM    #      ##  #  #   #         ## ##   # #     #    ##  #         #   #  #   #  #   #  #
REM    ####   # # #  #   #         # # #  #   #    #    # # #         #      #   #  #   #  ####
REM    #      #  ##  #   #         # # #  #####    #    #  ##         #   #  #   #  #   #  #
REM    #####  #   #  ####          #   #  #   #   ###   #   #          ###    ###   ####   #####



REM Change formatting for the start and end times
FOR /F "tokens=1-4 delims=:.," %%a IN ("%STARTTIME%") DO (
 SET /A "start=(((%%a*60)+1%%b %% 100)*60+1%%c %% 100)*100+1%%d %% 100"
)

FOR /F "tokens=1-4 delims=:.," %%a IN  ("%ENDTIME%") DO (
 SET /A "end=(((%%a*60)+1%%b %% 100)*60+1%%c %% 100)*100+1%%d %% 100"
)

REM Calculate the elapsed time by subtracting values
SET /A elapsed=end-start

REM Format the results for output
SET /A hh=elapsed/(60*60*100), rest=elapsed%%(60*60*100), mm=rest/(60*100), rest%%=60*100, ss=rest/100, cc=rest%%100
IF %hh% lss 10 SET hh=0%hh%
IF %mm% lss %v_MIN_MINS%  SET "v_RERUN=Y"
IF %mm% lss 10 SET mm=0%mm%
IF %ss% lss 10 SET ss=0%ss%
IF %cc% lss 10 SET cc=0%cc%

SET DURATION=%hh%:%mm%:%ss%.%cc%

:: Send metric to Introscope to tell how many minutes the job ran
CALL MessageRequest.bat WMI_UserGroup_Job Duration %mm%
::

CALL :LOG_OUTPUT " Start    : %STARTTIME%" " Finish   : %ENDTIME%" " Duration : %DURATION% "

IF %v_RERUN%==Y (
   IF [.%SECOND_RUN%TEST] EQU [.2TEST] (
      CALL :LOG_OUTPUT "Second Run also Failed, Notify BMS Windows SysAdmins"
      CALL :LOG_OUTPUT "Echoing FAIL Date/Time into FILE: %WMI_PATH%\FAIL.txt"
      ECHO FAIL Second Time of WMI at %DATE% %TIME% >%WMI_PATH%\FAIL.txt
      CALL :LOG_OUTPUT "Send metric to Introscope to tell we had an internal failure, and this should reach a threashold that is Reported to System Admins"
      CALL MessageRequest.bat WMI_UserGroup_Job Status 2
::
      EXIT 1
   ) ELSE (
      CALL :LOG_OUTPUT "WMI did NOT run long Enough, Sleeping 3 minutes"
      PING -N 180 127.0.0.1 >NUL 2>&1
      CALL :LOG_OUTPUT "WMI did NOT run long Enough, Re-Running now"
      START "WMI Re-Run" /D %WMI_PATH%\ /MIN /B %WMI_PATH%\WMI_Wrapper.BAT 2
      CALL :LOG_OUTPUT "Send metric to Introscope to tell that we had an initial failure"
      CALL MessageRequest.bat WMI_UserGroup_Job Status 1
::
      GOTO :EOF      
   )
) ELSE (
   CALL :LOG_OUTPUT "Send metric to Introscope to tell that the job status is normal"
   CALL MessageRequest.bat WMI_UserGroup_Job Status 0
)
GOTO :END_OF_SCRIPT

::    ####    ###    ####         #####                              #####                        #       #
::    #   #  #   #  #               #    #   #  ####    ###          #      #   #  # ##    ###   ####           ###   # ##    ####
::    #   #  #   #   ###            #    #   #  #   #  #####         ####   #   #  ##  #  #       #       #    #   #  ##  #  ###
::    #   #  #   #      #           #     ####  #   #  #             #      #  ##  #   #  #       #       #    #   #  #   #    ###
::    ####    ###   ####            #        #  ####    ###          #       ## #  #   #   ###     ##     #     ###   #   #  ####
::                                        ###   #
::                         #####                             #######

:GET_NOW
            ::      ####  #####  #####         #   #   ###   #   # 
            ::     #      #        #           ##  #  #   #  # # # 
            ::     #  ##  ####     #           # # #  #   #  # # # 
            ::     #   #  #        #           #  ##  #   #  ## ## 
            ::      ####  #####    #           #   #   ###   #   # 
            ::                          #####                      
   FOR /f "tokens=3 delims=: " %%a in ('time /T') DO SET "TEMP_ampm=%%a"
   SET "TEMP_TODAY="
   SET "TEMP_NOW=%date:~10,4%-%date:~4,2%-%date:~7,2% %time:~0,2%:%time:~3,2%:%time:~6,2%_%TEMP_ampm%"
   SET "TEMP_NOW=%TEMP_NOW: =0%"& 
   GOTO :EOF

:LOG_OUTPUT
            ::--------------------------------------------------------------------------
            ::   #       ###    ####          ###   #   #  #####  ####   #   #  ##### 
            ::   #      #   #  #             #   #  #   #    #    #   #  #   #    #   
            ::   #      #   #  #  ##         #   #  #   #    #    ####   #   #    #   
            ::   #      #   #  #   #         #   #  #   #    #    #      #   #    #   
            ::   #####   ###    ####          ###    ###     #    #       ###     #  
            ::--------------------------------------------------------------------------
            ::   This DOS type function allows 3 bits of info to be passed and grouped 
            ::   into the ---- sections of the Log file
            ::--------------------------------------------------------------------------
                                                                      
   CALL :GET_NOW
   ECHO +-------------------------------------------------------------------------------------------------------+ >> %v_LOGFILE%
   ECHO [ %TEMP_NOW% ] %~1 >> %v_LOGFILE%
   IF /I "%~2" NEQ "" (
      ECHO [ %TEMP_NOW% ] %~2 >> %v_LOGFILE%
   )
   IF /I "%~3" NEQ "" (
      ECHO [ %TEMP_NOW% ] %~3 >> %v_LOGFILE%
   )
   ECHO +-------------------------------------------------------------------------------------------------------+ >> %v_LOGFILE%
   GOTO :EOF
:END_OF_SCRIPT
   CALL :LOG_OUTPUT "Cleaning up Files older than 30 days";
   FORFILES /P %WMI_PATH%\LOGS\ /S /M *.log /D -30 /C "cmd /c del @PATH" 2>NUL
   CALL :LOG_OUTPUT "Script End -- EOF"
:EOF
EXIT